//const uint8_t NO_OF_CYLINDERS = 1;
const int16_t MIN_USROT_ENG = 4000; // for table data calculation = 15000 rpm
const int16_t MIN_ALLOWED_USROT_ENG = 4000; // 4000 red line: Max RPM = 15000
const int32_t MAX_ALLOWED_USROT_ENG = 400000; // if rot is higher: engine too slow to start (=150 RPM)
const int32_t MAX_INACTIVE_DURATION = 1000000; // if this time 1s (in µs) is exceeded without trigger signal, engine is assumed to be stopped
const int32_t MAX_USROT_ENG = 80000; // MIN RPM = 750 RPM for tabular calculation
const int16_t USROT_INCR_ENG = 1000; // time increment for calculating tabular values
const uint8_t BASE_ADVANCE = 42; //

const uint8_t TABLE_SIZE = ( MAX_USROT_ENG - MIN_USROT_ENG ) / USROT_INCR_ENG + 1; // no of items in time/delay table
const uint8_t MAX_TABLE_INDEX = TABLE_SIZE - 1;

const uint8_t NO_OF_CURVES = 1;// we have 1 ignition curves with different characteristics
const uint8_t NO_OF_POINTS_PER_CURVE = 6; // each curve is defined by 5 points (pairs of RPM/advance angle)


// For the ignition curves we store RPM/100 instead of RPM to save memory (we can use uint8_t instead of int)
// IMPORTANT: These are RPMs of the crankshaft (Kurbelwelle in German), but the hall sensor is attached to the camshaft (Nockenwelle in German)
// which rotates at half the RPM (=twice the time) of the crankshaft. We will have to consider this (see below)
const uint8_t CURVE_DATA[ NO_OF_CURVES * NO_OF_POINTS_PER_CURVE ][ 2 ] = {
  {10, 14},   // 1000 RPM = 60ms/R
  {15, 16},   // 1500 RPM = 40ms/R 
  {20, 19},   // 2000 RPM = 30ms/R
  {30, 30},   // 3000 RPM = 20ms/R
  {40, 35},   // 4000 RPM = 15ms/R
  {50, 37}};   // 5000 RPM = 12ms/R


//  {99, 37},   // 10000 RPM = 6ms/R
//  {110, 30}};  // 11000 RPM = ms/R
